/* clean up the data by industry */
*use /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/Stabu/stabu_ind.dta

* normalize with Q1 1991

/* bruttowertschoepfung */
* total
*gen va_n=va_n_w
*replace va_n=va_n_u*(313.91/341.13) if year>=1991
gen va_n=va_n_u
replace va_n=va_n_w*(341.13/313.91) if year<1991
drop va_n_u va_n_w
label var va_n "Value added seas adj nominal bill Euros"
* agric
*gen vaag_n=vaag_n_w
*replace vaag_n=vaag_n_u*(3.95/4.7) if year>=1991
gen vaag_n=vaag_n_u
replace vaag_n=vaag_n_w*(4.7/3.95) if year<1991
drop vaag_n_u vaag_n_w
* manufacturing (produzierendes gewerbe)
*gen vaman_n=vaman_n_w
*replace vaman_n=vaman_n_u*(100.79/108.87) if year>=1991
gen vaman_n=vaman_n_u
replace vaman_n=vaman_n_w*(108.87/100.79) if year<1991
drop vaman_n_u 
*drop vaman_n_w
label var vaman_n "Value added manufacturing seas adj nominal bill Euros"
* verarbeitende gewerbe (subset)
*gen vamansub_n=vamansub_n_w
*replace vamansub_n=vamansub_n_u*(92.36/98.5) if year>=1991
gen vamansub_n=vamansub_n_u
replace vamansub_n=vamansub_n_w*(98.5/92.36) if year<1991
drop vamansub_n_u vamansub_n_w
* construction
*gen vacons_n=vacons_n_w
*replace vacons_n=vacons_n_u*(17.25/19.3) if year>=1991
gen vacons_n=vacons_n_u
replace vacons_n=vacons_n_w*(19.3/17.25) if year<1991
drop vacons_n_u vacons_n_w
* trade, hospitality
*gen vatrade_n=vatrade_n_w
*replace vatrade_n=vatrade_n_u*(56.39/61.73) if year>=1991
gen vatrade_n=vatrade_n_u
replace vatrade_n=vatrade_n_w*(61.73/56.39) if year<1991
drop vatrade_n_u vatrade_n_w
* finance etc.
*gen vafin_n=vafin_n_w
*replace vafin_n=vafin_n_u*(74.59/77.63) if year>=1991
gen vafin_n=vafin_n_u
replace vafin_n=vafin_n_w*(77.63/74.59) if year<1991
drop vafin_n_u vafin_n_w
* other services
*gen vaserv_n=vaserv_n_w
*replace vaserv_n=vaserv_n_u*(60.94/68.9) if year>=1991
gen vaserv_n=vaserv_n_u
replace vaserv_n=vaserv_n_w*(68.9/60.94) if year<1991
drop vaserv_n_u vaserv_n_w

/* now make real */
gen va_r=100*(va_n/gdp_def)
gen vaag_r=100*(vaag_n/gdp_def)
gen vaman_r=100*(vaman_n/gdp_def)
gen vaman_r_w=100*(vaman_n_w/gdp_def)
gen vamansub_r=100*(vamansub_n/gdp_def)
gen vacons_r=100*(vacons_n/gdp_def)
gen vatrade_r=100*(vatrade_n/gdp_def)
gen vafin_r=100*(vafin_n/gdp_def)
gen vaserv_r=100*(vaserv_n/gdp_def)

drop va_n-vaserv_n vaman_n_w 
label var va_r "Real value added"
label var vaag_r "Real value added agriculture"
label var vaman_r "Real value added manufacturing"
label var vamansub_r "Real value added verarbeit.gewerb (subset)"
label var vacons_r "Real value added construction"
label var vatrade_r "Real value added trade, hosp"
label var vafin_r "Real value added finance etc"
label var vaserv_r "Real value added other services"

/* employment */
* total - nb should be repeating existing var
*gen empl2=empl2_w
*replace empl2=empl2_u*(31033/39008) if year>=1991
gen empl2=empl2_u
replace empl2=empl2_w*(39008/31033) if year<1991
drop empl2_u empl2_w
label var empl2 "Employment seas adj 000s"

* agric
*gen emplag=emplag_w
*replace emplag=emplag_u*(1040/1648) if year>=1991
gen emplag=emplag_u
replace emplag=emplag_w*(1648/1040) if year<1991
drop emplag_u emplag_w
* manufacturing (produzierendes gewerbe)
*gen emplman=emplman_w
*replace emplman=emplman_u*(9234/11713) if year>=1991
gen emplman=emplman_u
replace emplman=emplman_w*(11713/9234) if year<1991
drop emplman_u 
*drop emplman_w
label var emplman "Employment manufacturing seas adj 000s"
* verarbeitende gewerbe (subset)
*gen emplmansub=emplmansub_w
*replace emplmansub=emplmansub_u*(8744/10947) if year>=1991
gen emplmansub=emplmansub_u
replace emplmansub=emplmansub_w*(10947/8744) if year<1991
drop emplmansub_u emplmansub_w
* construction
*gen emplcons=emplcons_w
*replace emplcons=emplcons_u*(2072/2772) if year>=1991
gen emplcons=emplcons_u
replace emplcons=emplcons_w*(2772/2072) if year<1991
drop emplcons_u emplcons_w
* trade, hospitality
*gen empltrade=empltrade_w
*replace empltrade=empltrade_u*(7656/9320) if year>=1991
gen empltrade=empltrade_u
replace empltrade=empltrade_w*(9320/7656) if year<1991
drop empltrade_u empltrade_w
* finance etc.
*gen emplfin=emplfin_w
*replace emplfin=emplfin_u*(3204/3663) if year>=1991
gen emplfin=emplfin_u
replace emplfin=emplfin_w*(3663/3204) if year<1991
drop emplfin_u emplfin_w
* other services
*gen emplserv=emplserv_w
*replace emplserv=emplserv_u*(7830/9880) if year>=1991
gen emplserv=emplserv_u
replace emplserv=emplserv_w*(9880/7830) if year<1991
drop emplserv_u emplserv_w
